% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_all_stats.R
\name{calc_all_stats}
\alias{calc_all_stats}
\title{Apply all available tree statistics to a single tree}
\usage{
calc_all_stats(phylo, normalize = FALSE)
}
\arguments{
\item{phylo}{phylo object}

\item{normalize}{if set to TRUE, results are normalized (if possible) under
either the  Yule expectation (if available), or the number of tips}
}
\value{
List with statistics
}
\description{
this function applies all tree statistics available in
this package to a
single tree, being:
\itemize{
  \item gamma
  \item Sackin
  \item Colless
  \item corrected Colless
  \item quadratic Colless
  \item Aldous' beta statistic
  \item Blum
  \item crown age
  \item tree height
  \item Pigot's rho
  \item number of lineages
  \item nLTT with empty tree
  \item phylogenetic diversity
  \item avgLadder index
  \item cherries
  \item double cherries
  \item ILnumber
  \item pitchforks
  \item stairs
  \item stairs2
  \item laplacian spectrum
  \item B1
  \item B2
  \item area per pair (aPP)
  \item average leaf depth (aLD)
  \item I statistic
  \item ewColless
  \item max Delta Width (maxDelW)
  \item maximum of Depth
  \item variance of Depth
  \item maximum Width
  \item Rogers
  \item total Cophenetic distance
  \item symmetry Nodes
  \item mean of pairwise distance (mpd)
  \item variance of pairwise distance (vpd)
  \item Phylogenetic Species Variability (psv)
  \item mean nearest taxon distance (mntd)
  \item J statistic of entropy
  \item rquartet index
  \item Wiener index
  \item max betweenness
  \item max closeness
  \item diameter, without branch lenghts
  \item maximum eigen vector value
  \item mean branch length
  \item variance of branch length
  \item mean external branch length
  \item variance of external branch length
  \item mean internal branch length
  \item variance of internal branch length
  \item number of imbalancing steps
  \item j_one statistic
  \item treeness statistic
}

For the Laplacian spectrum properties, four properties of the eigenvalue
distribution are returned: 1) asymmetry, 2) peakedness, 3) log(principal
eigenvalue) and 4) eigengap.
Please notice that for some very small or very large trees, some of the
statistics can not be calculated. The function will report an NA for this
statistic, but will not break, to facilitate batch analysis of large numbers
of trees.
}
