% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize Text}
\usage{
normalize(...)
}
\arguments{
\item{...}{Any number of vectors containing \link{atomic} elements. Each vector
is normalized as a paragraph.
\itemize{
\item Elements are coerced to character values.
\item NA values and empty strings are discarded.
\item Multi-line strings are supported and encouraged. Blank lines are
interpreted (two or more newline characters) as paragraph separators.
}}
}
\value{
A character string, possibly empty.
}
\description{
Construct a standardized string from values passed to \code{...}
}
\details{
Input text can written in a variety of ways using single-line and multi-line
strings. Values passed to \code{...} are normalized (to ensure their consistency)
and collapsed to a single character string using the standard paragraph
separator. The latter is defined as two newline characters (\code{"\\n\\n"}).
\enumerate{
\item NA values and empty strings are discarded before reducing \code{...} to a
character string.
\item Whitespaces (tabs, newlines, and repeated spaces) characters are
replaced by a single space. Paragraph separators are preserved.
\item Leading or trailing whitespaces are stripped.
}
}
\keyword{internal}
