% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-location.R
\name{location}
\alias{location}
\alias{Location}
\alias{is_location}
\alias{format.Location}
\alias{print.Location}
\alias{c.Location}
\alias{merge_locations}
\title{Source Locations}
\usage{
location(path = tempfile(), line1 = 1L, col1 = 1L, line2 = 1L, col2 = 1L)

is_location(x)

\method{format}{Location}(x, ...)

\method{print}{Location}(x, ...)

\method{c}{Location}(...)

merge_locations(...)
}
\arguments{
\item{path}{A non-empty and non-NA character string. The origin of the ranges.}

\item{line1, col1}{A non-empty integer vector of non-NA values. The
(inclusive) starting point(s) of what is being referenced.}

\item{line2, col2}{A non-empty integer vector of non-NA values. The
(inclusive) end(s) of what is being referenced.}

\item{x}{Any \R object.}

\item{...}{Usage depends on the underlying function.
\itemize{
\item Any number of \code{\link{Location}} objects for \code{\link[=merge_locations]{merge_locations()}}
and S3 method \code{\link[=c]{c()}}.
\item Further arguments passed to or from other methods for \code{\link[=format]{format()}} and
\code{\link[=print]{print()}}.
}}
}
\value{
\code{\link[=location]{location()}}, and \code{\link[=c]{c()}} return a named list of length 5 and of S3 class
\code{\link{Location}} containing the values of \code{path}, \code{line1}, \code{col1},
\code{line2}, and \code{col2}.

\code{\link[=is_location]{is_location()}} returns a logical value.

\code{\link[=format]{format()}} returns a character vector.

\code{\link[=print]{print()}} returns argument \code{x} invisibly.

\code{\link[=merge_locations]{merge_locations()}} returns a list of (combined) \code{\link{Location}}
objects.
}
\description{
Structure and manipulate source locations. Class \code{\link{Location}} is
a lighter alternative to \code{\link[=srcfile]{srcfile()}} and other related functionalities.
}
\details{
A \code{\link{Location}} is a set of one or more line/column ranges
referencing contents (like text or source code) within a common \emph{origin}
identified by an underlying \code{path}. The latter is generic and can be
\emph{anything}: a file on disk, on a network, a pointer, a binding, etc. What
matters is the underlying context.

\code{\link{Location}} objects may refer to multiple distinct ranges for
the the same origin. This is why arguments \code{line1}, \code{col1}, \code{line2} and
\code{col2} accept integer vectors (and not only scalar values).
\subsection{Combining Location Objects}{

\code{\link[=c]{c()}} can only combine \code{\link{Location}} objects having the same
\code{path}. In that case, the underlying ranges are combined into a set of
non-duplicated range(s).

\code{\link[=merge_locations]{merge_locations()}} is a generalized version of \code{\link[=c]{c()}} that handles any
number of \code{\link{Location}} objects having possibly different paths.
It can be viewed as a vectorized version of \code{\link[=c]{c()}}.
}
}
\examples{
# Create Location objects.
loc1 <- location("file-a", 1L, 2L, 3L, 4L)
loc2 <- location("file-a", 5L, 6L, 7L, 8L)
loc3 <- location("file-c", c(9L, 10L), c(11L, 12L), c(13L, 14L), c(15L, 16L))

is_location(loc1)  ## TRUE

print(loc1)
print(loc2)
print(loc3)

# Combine Location objects.
# c() throws an error if they do not have the same path.
c(loc1, loc2)

# Location objects with different paths can be merged.
# This groups Location objects according to their paths
# and calls c() on each group. It returns a list.
merge_locations(loc1, loc2, loc3)

# The path of a Location object can be whatever fits the context.
# Below is an example that references text in a character vector
# bound to variable x in the global environment.
x <- "This is a string and it is held in memory for some purpose."
location("<environment: R_GlobalEnv: x>", 1L, 11L, 1L, 16L)

}
\keyword{internal}
