% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{lines.Trajectory}
\alias{lines.Trajectory}
\title{Add Trajectory lines to a plot}
\usage{
\method{lines}{Trajectory}(
  x,
  draw.start.pt = TRUE,
  start.pt.cex = 0.8,
  start.pt.pch = 16,
  start.pt.col = "black",
  turning.angles = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class "Trajectory", the trajectory to be plotted.}

\item{draw.start.pt}{If TRUE, draws a dot at the start point of the
trajectory.}

\item{start.pt.cex}{Scale to apply when drawing the start point dot.}

\item{start.pt.pch}{Pch (i.e. plot character, symbol or shape) to apply when
drawing the start point dot.}

\item{start.pt.col}{Colour to apply when drawing the start point dot.}

\item{turning.angles}{If \code{"random"} or \code{"directed"}, draws step turning
angles. \code{"directed"} assumes errors are relative to the first recorded
step angle. \code{"random"} assumes errors are relative to the previous step.}

\item{...}{Additional arguments are passed to \code{\link[graphics]{lines}}.}
}
\description{
The \code{lines} method for Trajectory objects.
}
