% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractal.R
\name{TrajFractalDimensionValues}
\alias{TrajFractalDimensionValues}
\title{Fractal dimension calculation}
\usage{
TrajFractalDimensionValues(trj, stepSizes, adjustD = TRUE)
}
\arguments{
\item{trj}{Trajectory to calculate fractal dimension for.}

\item{stepSizes}{Vector of step sizes used to calculate path lengths.}

\item{adjustD}{If TRUE, path length is adjusted to reduce truncation error
(Nams, 2006).}
}
\value{
Data frame with columns \code{stepsize} (\eqn{\delta}) and
  \code{pathlength} ((\eqn{L(\delta)}).
}
\description{
Calculates path length (\eqn{L(\delta)}) for a range of step sizes
(\eqn{\delta}). For a fractal (i.e. scale independent) curve,
\eqn{log(L(\delta))} grows linearly as \eqn{log(\delta)} grows smaller. In
other words, if the points returned by this function lie on a straight line
in a log-log plot, \code{trj} is a fractal curve.
}
\examples{
set.seed(42)
trj <- TrajGenerate()
muL <- mean(TrajStepLengths(trj))
# Use 20 step sizes from 1/2 mean step length to 5 * mean step length.
# For real use, biologically meaningful step sizes should be used.
stepSizes <- TrajLogSequence(0.5 * muL, 5 * muL, 20)
plot(TrajFractalDimensionValues(trj, stepSizes), log = "xy", pch = 16, cex = .5)

}
\references{
Nams, V. O. (2006). Improving Accuracy and Precision in Estimating Fractal
Dimension of Animal movement paths. Acta Biotheoretica, 54(1), 1-11.
doi:10.1007/s10441-006-5954-8
}
\seealso{
\code{\link{TrajFractalDimension}} for fractal dimension
  calculation.
}
