% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractal.R
\name{TrajFractalDimension}
\alias{TrajFractalDimension}
\title{Fractal dimension of a trajectory}
\usage{
TrajFractalDimension(trj, stepSizes, adjustD = TRUE, dMean = TRUE)
}
\arguments{
\item{trj}{Trajectory to calculate fractal dimension for.}

\item{stepSizes}{Vector of step sizes (aka divider sizes) used to calculate
path lengths.}

\item{adjustD}{If \code{TRUE}, path length is adjusted for truncation error
(Nams, 2006).}

\item{dMean}{If \code{TRUE}, the fractal dimension is calculated starting
from the beginning of the trajectory, then re-calculated starting from the
end and moving backwards. The value returned is the mean of the two fractal
dimensions (Nams, 2006).}
}
\value{
The fractal dimension of the trajectory for the given step sizes.
}
\description{
Calculates the fractal dimension (\code{D}) of a trajectory using the
'dividers' method (Sugihara & May, 1990). By default, overestimation of
\code{D} is compensated for as recommended by Nams (2006), by walking the
dividers backwards and forwards, and by estimating the remaining path length
at the end of the last step.
}
\details{
Fractal dimension may be meaningless for animal trajectories as they may not
be true fractal curves - see Benhamou (2004) and Turchin (1996), although it
may be useful for studies involving differences in behaviour at different
spatial scales (Nams, 2006).

You can test whether a trajectory is a fractal curve for a range of step
sizes using the \code{\link{TrajFractalDimensionValues}} function. The
example code in its documentation demonstrates how to plot path length for a
range of step sizes. If the plotted points lie along straight line, then the
trajectory is a fractal curve for that range of step sizes. However, typical
trajectories result in a curve rather than a straight line.

If you decide to use fractal dimension despite the warnings of Benhamou
(2004) and Turchin (1996), try to select a biologically meaningful range of
step sizes (and be prepared to justify your choice). If comparing fractal
dimensions across trajectories, be consistent in your choice of step sizes.
}
\references{
Benhamou, S. (2004). How to reliably estimate the tortuosity of an animal's
path. Journal of Theoretical Biology, 229(2), 209-220.
doi:10.1016/j.jtbi.2004.03.016

Nams, V. O. (2006). Improving Accuracy and Precision in Estimating Fractal
Dimension of Animal movement paths. Acta Biotheoretica, 54(1), 1-11.
doi:10.1007/s10441-006-5954-8

Sugihara, G., & M. May, R. (1990). Applications of fractals in ecology.
Trends in Ecology & Evolution, 5(3), 79-86. doi:10.1016/0169-5347(90)90235-6

Turchin, P. (1996). Fractal Analyses of Animal Movement: A Critique. Ecology,
77(7), 2086-2090. doi:10.2307/2265702
}
\seealso{
\code{\link{TrajLogSequence}} to create a logarithmically spaced
  sequence, \code{\link{TrajFractalDimensionValues}} for the function used
  internally to calculate a range of path lengths for different step sizes,
  \code{\link{TrajEmax}} and \code{\link{TrajSinuosity2}} for some alternate
  measures of trajectory tortuosity.
}
