% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{missing_data}
\alias{missing_data}
\title{Find Missing Data in a Track Table}
\usage{
missing_data(x, begin = NULL, end = NULL, step = NULL)
}
\arguments{
\item{x}{A \code{\link{track}} table as produced by the \code{\link{track}}
function.}

\item{begin}{A full time stamp (date+time) in \code{\link{POSIXct}} format
corresponding to the time from which the missing data should be looked for.
If not set, the first time stamp of the track table will be used.}

\item{end}{A full time stamp (date+time) in \code{\link{POSIXct}} format
corresponding to the time until which the missing data should be looked for.
If not set, the last time stamp of the track table will be used.}

\item{step}{A \code{\link{difftime}} object representing the expected time
between two consecutive locations of the trajectory. If not set, it is set
to the most common time difference between successive locations in \code{x}.}
}
\value{
A track table of all observations with missing data. The missing data
 is indicated with \code{\link{NA}}.
}
\description{
This function attempts to automatically detect missing data (for
 instance due to writing errors) in \code{\link{track}} tables.
}
\examples{
# Create data set with missing time stamps
data(short_tracks)
t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
              id = short_tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df <- t_df[-c(10, 100), ]

# Find missing data
missing <- missing_data(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
