% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_functions.R
\name{extract_ladder_summary}
\alias{extract_ladder_summary}
\title{Extract ladder summary}
\usage{
extract_ladder_summary(fragments_trace_list, sort = FALSE)
}
\arguments{
\item{fragments_trace_list}{a list of fragments trace objects}

\item{sort}{A logical statement for if the samples should be ordered by average ladder R-squared.}
}
\value{
a dataframe of ladder quality information
}
\description{
Extract a table summarizing the ladder models
}
\details{
The ladder peaks are assigned using a custom algorithm that maximizes the fit of detected ladder peaks and given base-pair sizes. This function summarizes the R-squared values of these individual correlations.
}
\examples{

  fsa_list <- lapply(cell_line_fsa_list, function(x) x$clone())

  find_ladders(fsa_list, show_progress_bar = FALSE)

  extract_ladder_summary(fsa_list, sort = TRUE)
}
