% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-better.r
\name{search_better}
\alias{search_better}
\title{Search for a better projection near the current projection.}
\usage{
search_better(
  current,
  alpha = 0.5,
  index,
  tries,
  max.tries = Inf,
  ...,
  method = "linear",
  cur_index = NA
)
}
\arguments{
\item{current}{starting projection}

\item{alpha}{the angle used to search the target basis from the current basis}

\item{index}{index function}

\item{tries}{the counter of the outer loop of the opotimiser}

\item{max.tries}{maximum number of iteration before giving up}

\item{...}{other arguments being passed into the \code{search_better()}}

\item{method}{whether the nearby bases are found by a linear/ geodesic formulation}

\item{cur_index}{the index value of the current basis}
}
\description{
Search for a better projection near the current projection.
}
\examples{
animate_xy(flea[, 1:6], guided_tour(holes(), search_f = search_better))
}
\keyword{optimize}
