% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{logf}
\alias{logf}
\title{logf function}
\usage{
logf(
  fmt,
  ...,
  file = .Options$toscutil.logf.file \%||\% "",
  append = .Options$toscutil.logf.append \%||\% FALSE,
  prefix = .Options$toscutil.logf.prefix \%||\% function() now_ms(usetz = FALSE, color =
    fg$GREY),
  sep1 = .Options$toscutil.logf.sep1 \%||\% " ",
  sep2 = .Options$toscutil.logf.sep2 \%||\% "",
  end = .Options$toscutil.logf.end \%||\% "\\n"
)
}
\arguments{
\item{...}{Arguments to be passed to sprintf for string formatting.}

\item{file}{A \code{\link[=file]{file()}} connection object or a string naming the file to print to. If \code{""} (the default), output is printed to STDOUT unless redirected by \code{\link[=sink]{sink()}}.}

\item{append}{Logical. If \code{TRUE}, the output is appended to the file. If \code{FALSE}, the file is overwritten.}

\item{prefix}{A function returning a string to be used as the prefix.}

\item{sep1}{A string to be used as the separator between the prefix and the formatted string.}

\item{sep2}{A string to be used as the separator between the formatted string and the end.}

\item{end}{A string to be used as the end of the message.}
}
\value{
No return value. This function is called for its side effect of printing a message.
}
\description{
Prints a formatted string with optional prefix and end string. The default prefix is a grey timestamp and the default end is a newline character, which is useful for logging messages. All defaults can be set globally using \code{\link[=options]{options()}}. For details see 'Examples'.
}
\examples{
logf("Hello, \%s!", "world")
logf("Goodbye", prefix = function() "", sep1 = "", end = "!\n")
local({
     opts <- options(toscutil.logf.prefix = function() "LOG:", toscutil.logf.end = "\n")
     on.exit(options(opts))
     logf("Hello, \%s!", "world")
})
}
\keyword{internal}
