% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{check_pkg_docs}
\alias{check_pkg_docs}
\title{Check Documented Functions in a Package}
\usage{
check_pkg_docs(pkg = NULL)
}
\arguments{
\item{pkg}{The package name. If NULL, the package name is inferred from the DESCRIPTION file in the current directory or any parent directory. If no DESCRIPTION file is found, the function stops with an error message.}
}
\value{
Returns a dataframe with columns \code{title}, \code{description}, \code{value}, \code{examples} and rows corresponding to the documented functions in the package. Each cell contains a string describing the check result for the corresponding documentation element of that function.
}
\description{
Lists all documented functions in a package and checks their documentation elements for potential issues. The following checks are performed:
\enumerate{
\item Title is present and doesn't start with regex "Function".
\item Description is present and doesn't start with "This function".
\item Value is present.
\item Example is present.
}
}
\examples{
df <- check_pkg_docs("tools")
try(df <- check_pkg_docs())
}
\keyword{doc}
