% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{scale_rm}
\alias{scale_rm}
\title{Standardises matrices with multiple measurements per individual.}
\usage{
scale_rm(mat, origin = NULL, centre = FALSE)
}
\arguments{
\item{mat}{A matrix.}

\item{origin}{Measurement of reference for stardadisation.}

\item{centre}{Logical. TRUE to centre data. Default is FALSE.}
}
\value{
Returns scaled and/or centred values for repeated measurements.
}
\description{
This function stardadises matrices with multiple measurements
w.r.t. a chosen origin.
}
\examples{
#sample size etc
N = 10
p = 25
q = 5
# noise
X0 = sapply(1:p, function(x) rnorm(N))
Y0 = sapply(1:q, function(x) rnorm(N))

colnames(X0) = paste0("x", 1:p)
colnames(Y0) = paste0("y", 1:q)

# signal
Z1 = rnorm(N,0,1)


#Some associations with the true signal
alpha = (6:10) / 10
beta  = -(2:3) / 10

loc_alpha = 1:length(alpha)
loc_beta  = 1:length(beta)

for(j in 1:length(alpha))
  X0[, loc_alpha[j]] =  alpha[j] * Z1 + rnorm(N,0,0.3)

for(j in 1:length(beta))
  Y0[, loc_beta[j]] =  beta[j] * Z1 + rnorm(N,0,0.3)

X = standardVar(X0)
Y = standardVar(Y0)
}
