% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_cosine_embedding_loss}
\alias{nn_cosine_embedding_loss}
\title{Cosine embedding loss}
\usage{
nn_cosine_embedding_loss(margin = 0, reduction = "mean")
}
\arguments{
\item{margin}{(float, optional): Should be a number from \eqn{-1} to \eqn{1},
\eqn{0} to \eqn{0.5} is suggested. If \code{margin} is missing, the
default value is \eqn{0}.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed.}
}
\description{
Creates a criterion that measures the loss given input tensors
\eqn{x_1}, \eqn{x_2} and a \code{Tensor} label \eqn{y} with values 1 or -1.
This is used for measuring whether two inputs are similar or dissimilar,
using the cosine distance, and is typically used for learning nonlinear
embeddings or semi-supervised learning.
The loss function for each sample is:
}
\details{
\deqn{
  \mbox{loss}(x, y) =
  \begin{array}{ll}
1 - \cos(x_1, x_2), & \mbox{if } y = 1 \\
\max(0, \cos(x_1, x_2) - \mbox{margin}), & \mbox{if } y = -1
\end{array}
}
}
