% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{check_gaussian_convergence}
\alias{check_gaussian_convergence}
\title{Model Diagnostics and Convergence Testing
Check Multivariate Gaussian Convergence}
\usage{
check_gaussian_convergence(data, window_size = 300, tolerance = 0.01)
}
\arguments{
\item{data}{Matrix or Data Frame. A matrix of samples where columns are parameters.}

\item{window_size}{Integer. The size of the sliding window used to compute statistics.}

\item{tolerance}{Numeric. The convergence threshold for the relative change in the
mean and covariance.}
}
\value{
An object of class \code{topolow_convergence} containing diagnostics about the
convergence of the multivariate samples. This list includes logical flags for
convergence (\code{converged}, \code{mean_converged}, \code{cov_converged}) and the history
of the mean and covariance changes.
}
\description{
Assesses the convergence of multivariate samples by monitoring the stability of the
mean vector and covariance matrix over a sliding window. This is useful for checking
if a set of parameter samples has stabilized.
}
\examples{
# Create sample data for the example
chain_data <- as.data.frame(matrix(rnorm(500 * 4), ncol = 4))
colnames(chain_data) <- c("param1", "param2", "param3", "param4")

# Run the convergence check
conv_results <- check_gaussian_convergence(chain_data)
print(conv_results)

# The plot method for this object can be used to create convergence plots.
# plot(conv_results)
}
