% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnl.Test.R
\name{tnl.test}
\alias{tnl.test}
\alias{ptnl}
\alias{dtnl}
\alias{qtnl}
\alias{rtnl}
\alias{tnl_mean}
\alias{ptnl.lehmann}
\alias{dtnl.lehmann}
\alias{qtnl.lehmann}
\alias{rtnl.lehmann}
\title{Non-parametric tests for the two-sample problem based
on order statistics and power comparisons}
\usage{
tnl.test(x, y, l, exact = "NULL")

ptnl(q, n, m, l, exact = "NULL", trial = 1e+05)

dtnl(k, n, m, l, exact = "NULL", trial = 1e+05)

qtnl(p, n, m, l, exact = "NULL", trial = 1e+05)

rtnl(N, n, m, l)

tnl_mean(n., m., l)

ptnl.lehmann(q, n., m., l, gamma)

dtnl.lehmann(k, n., m., l, gamma)

qtnl.lehmann(p, n., m., l, gamma)

rtnl.lehmann(N, n., m., l, gamma)
}
\arguments{
\item{x}{the first (non-empty) numeric vector of data values.}

\item{y}{the second (non-empty) numeric vector of data values.}

\item{l}{class parameter of \eqn{T_n^{(\ell)}}.}

\item{exact}{the method that will be used. "NULL" or a logical
indicating whether an exact should be computed.
See 'Details' for the meaning of NULL.}

\item{n, m}{samples size.}

\item{trial}{number of trials for simulation.}

\item{k, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{N}{number of observations. If length(N) > 1, the length is taken
to be the number required.}

\item{n., m.}{samples size.}

\item{gamma}{parameter of Lehmann alternative.}
}
\value{
\code{\link{tnl.test}} returns a list with the following components
\describe{
\item{\code{statistic:}}{the value of the test statistic.}
\item{\code{p.value:}}{the p-value of the test.}}

\code{\link{ptnl}} returns a list with the following components
\describe{
\item{\code{method}:}{The method that was used (exact or simulation).
See 'Details'.}
\item{\code{cdf}:}{distribution function of \eqn{T_n^{(\ell)}}
against the specified quantiles.}
}

\code{\link{dtnl}} returns a list with the following components
\describe{
\item{\code{method}:}{The method that was used (exact or simulation).
See 'Details'.}
\item{\code{pmf}:}{density of \eqn{T_n^{(\ell)}}
against the specified quantiles.}
}

\code{\link{qtnl}} returns a list with the following components
\describe{
\item{\code{method}:}{The method that was used (exact or simulation).
See 'Details'.}
\item{\code{quantile}:}{quantile function against the specified
probabilities.}
}

\code{\link{rtnl}} return \emph{N} of the generated random values.

\code{\link[=tnl_mean]{tnl_mean()}} return the mean of \eqn{T_n^{(\ell)}}.

\code{\link{ptnl.lehmann}} return vector of the distribution under
Lehmann alternatives against the specified gamma.

\code{\link{dtnl.lehmann}} return vector of the density under Lehmann
alternatives against the specified gamma.

\code{\link{qtnl.lehmann}} returns a quantile function
against the specified probabilities under Lehmann alternatives.

\code{\link{rtnl.lehmann}} return \emph{N} of the generated random values
under Lehmann alternatives.
}
\description{
\code{\link{tnl.test}} performs a nonparametric test for
two sample test on vectors of data.

\code{\link{ptnl}} gives the distribution function of
\eqn{T_n^{(\ell)}} against the specified quantiles.

\code{\link{dtnl}} gives the density of \eqn{T_n^{(\ell)}}
against the specified quantiles.

\code{\link{qtnl}} gives the quantile function of
\eqn{T_n^{(\ell)}} against the specified probabilities.

\code{\link{rtnl}} generates random values from
\eqn{T_n^{(\ell)}}.

\code{\link[=tnl_mean]{tnl_mean()}} gives an expression for
\eqn{E(T_n^{(\ell)})} under \eqn{H_0:F=G}.

\code{\link{ptnl.lehmann}}  gives the  distribution function of
\eqn{T_n^{(\ell)}} under Lehmann alternatives.

\code{\link{dtnl.lehmann}}  gives the density of
\eqn{T_n^{(\ell)}} under Lehmann alternatives.

\code{\link{qtnl.lehmann}} gives the quantile function of
\eqn{T_n^{(\ell)}} against the specified probabilities under
Lehmann alternatives.

\code{\link{rtnl.lehmann}} generates random values from
\eqn{T_n^{(\ell)}} under Lehmann alternatives.
}
\details{
A non-parametric two-sample test is performed for testing null
hypothesis \eqn{H_0:F=G} against the alternative
hypothesis \eqn{H_1:F\not= G}.
The assumptions of the \eqn{T_n^{(\ell)}} test are that both
samples should come from a continuous distribution and the samples
should have the same sample size.

Missing values are silently omitted from \eqn{x} and \eqn{y}.

Exact and simulated p-values are available for the \eqn{T_n^{(\ell)}} test.
If exact ="NULL" (the default) the p-value is computed based
on exact distribution when the sample size is less than 11.
Otherwise, p-value is computed based on a Monte Carlo simulation.
If exact ="TRUE", an exact p-value is computed. If exact="FALSE"
, a Monte Carlo simulation is performed to compute the p-value.
It is recommended to calculate the p-value by a Monte Carlo simulation
(use exact="FALSE"), as it takes too long to calculate the exact
p-value when the sample size is greater than 10.

The probability mass function (pmf), cumulative density function (cdf)
and quantile function of \eqn{T_n^{(\ell)}}
are also available in this package, and the above-mentioned conditions
about exact ="NULL", exact ="TRUE" and exact="FALSE" is also valid
for these functions.

Exact distribution of \eqn{T_n^{(\ell)}}
test is also computed under Lehman alternative.

Random number generator of \eqn{T_n^{(\ell)}}
test statistic are provided under null hypothesis in the library.
}
\examples{
require(stats)
x <- rnorm(7, 2, 0.5)
y <- rnorm(5, 0, 1)
tnl.test(x, y, l = 2)
ptnl(q = c(2, 5), n = 6, m = 5, l = 2, trial = 100000)
dtnl(k = c(1, 3, 6), n = 7, m = 5, l = 2)
qtnl(p = c(.3, .9), n = 4, m = 5, l = 1)
rtnl(N = 20, n = 7, m = 10, l = 1)
require(base)
tnl_mean(n. = 11, m. = 8, l = 1)
ptnl.lehmann(q = 3, n. = 5, m. = 7, l = 2, gamma = 1.2)
dtnl.lehmann(k = 3, n. = 6, m. = 5, l = 2, gamma = 0.8)
qtnl.lehmann(p = c(.1, .5, .9), n. = 7, m. = 5, l = 1, gamma = 0.5)
rtnl.lehmann(N = 15, n = 7,m=7, l = 2, gamma = 0.5)
}
\references{
Karakaya, K., Sert, S., Abusaif, I., Kuş, C., Ng, H. K. T.,
& Nagaraja, H. N. (2023).
A Class of Non-parametric Tests for the Two-Sample Problem based on
Order Statistics and Power Comparisons. Submitted paper.

Aliev, F., Özbek, L., Kaya, M. F., Kuş, C., Ng, H. K. T.,
& Nagaraja, H. N. (2022). A nonparametric test for the two-sample problem
based on order statistics.
Communications in Statistics-Theory and Methods, 1-25.
}
