% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtuvn.R
\name{rtuvn}
\alias{rtuvn}
\title{Random number generation for truncated univariate normal distribution}
\usage{
rtuvn(n = 1, mean = 0, sd = 1, lower, upper)
}
\arguments{
\item{n}{number of random samples desired (sample size).}

\item{mean}{mean of the underlying univariate normal distribution.}

\item{sd}{standard deviation of the underlying univariate normal distribution.}

\item{lower}{lower bound for truncation.}

\item{upper}{upper bound for truncation.}
}
\value{
\code{rtuvn} returns a vector of random number follows truncated univariate normal distribution.
}
\description{
\code{rtuvn} simulates truncated univariate normal distribution within the interval.
}
\examples{
set.seed(1203)
ans <- rtuvn(n=1000, mean=1, sd=2, lower=-2, upper=3)
summary(ans)

# Check if the sample matches with CDF by KS test
ks.test(ans,"ptuvn",1,2,-2,3)

}
