% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDTM.R
\name{createDTM}
\alias{createDTM}
\alias{createTDM}
\title{Create a Chinese term-document matrix or a document-term matrix.}
\usage{
createDTM(string, language = c("zh", "en"), tokenize = NULL, removePunctuation = TRUE, 
  removeNumbers = TRUE, removeStopwords = TRUE)
createTDM(string, language = c("zh", "en"), tokenize = NULL, removePunctuation = TRUE, 
  removeNumbers = TRUE, removeStopwords = TRUE)
}
\arguments{
\item{string}{A character vector.}

\item{language}{The language type, 'zh' means Chinese.}

\item{tokenize}{A tokenizers function.}

\item{removePunctuation}{Whether to remove the punctuations.}

\item{removeNumbers}{Whether to remove the numbers.}

\item{removeStopwords}{Whether to remove the stop words.}
}
\value{
An object of class \code{TermDocumentMatrix} or class \code{DocumentTermMatrix}.
}
\description{
Create a Chinese term-document matrix or a document-term matrix.
}
\details{
Package "tm" is required.
}
\author{
Jian Li <\email{rweibo@sina.com}>
}
\keyword{NLP}
