% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_08_kRp.corpus-class_query.R
\docType{methods}
\name{query,kRp.corpus-method}
\alias{query,kRp.corpus-method}
\alias{query,kRp.hierarch-method}
\title{Apply query() to all texts in kRp.corpus objects}
\usage{
\S4method{query}{kRp.corpus}(
  obj,
  var,
  query,
  rel = "eq",
  as.df = TRUE,
  ignore.case = TRUE,
  perl = FALSE,
  regexp_var = "token"
)
}
\arguments{
\item{obj}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{var}{A character string naming a column in the tagged text. If set to
\code{"regexp"}, \code{grepl} is called on the column specified by \code{regexp_var}.}

\item{query}{A character vector (for words), regular expression,
      or single number naming values to be matched in the variable.
Can also be a vector of two numbers to query a range of frequency data,
      or a list of named lists for multiple queries (see
"Query lists" section of \code{\link[koRpus:query]{query}}).}

\item{rel}{A character string defining the relation of the queried value and desired results.
Must either be \code{"eq"} (equal, the default), \code{"gt"} (greater than),
      \code{"ge"} (greater of equal),
\code{"lt"} (less than) or \code{"le"} (less or equal). If \code{var="word"},
      is always interpreted as \code{"eq"}}

\item{as.df}{Logical, if \code{TRUE}, returns a data frame,
      otherwise an object of the input class.}

\item{ignore.case}{Logical, passed through to \code{grepl} if \code{var="regexp"}.}

\item{perl}{Logical, passed through to \code{grepl} if \code{var="regexp"}.}

\item{regexp_var}{A character string naming the column to query if \code{var="regexp"}.}
}
\value{
Depending on the arguments, might include whole objects, lists, single values etc.
}
\description{
This method calls \code{\link[koRpus:query]{query}} on all tagged text objects
inside the given object.
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Edwards"
    ),
    hierarchy=list(
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  query(myCorpus, var="lttr", query="7", rel="gt")
} else {}
}
\keyword{methods}
