% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_files.R
\name{corpus_files}
\alias{corpus_files}
\title{Get a comprehensive data frame describing the files of your corpus}
\usage{
corpus_files(
  dir,
  hierarchy = list(),
  fsep = .Platform$file.sep,
  full_list = FALSE
)
}
\arguments{
\item{dir}{File path to the root directory of the text corpus,
      or a TIF[1] compliant data frame.}

\item{hierarchy}{A named list of named character vectors describing the directory hierarchy level by level.
If \code{TRUE} instead, the hierarchy structure is taken directly from the directory tree.
See section Hierarchy of \code{\link[tm.plugin.koRpus:readCorpus]{readCorpus}} for details.}

\item{fsep}{Character string defining the path separator to use.}

\item{full_list}{Logical, see return value.}
}
\value{
Either a data frame with columns \code{doc_id}, \code{file},
      \code{path} and one further factor
   column for each hierarchy level,
      or (if \code{full_list=TRUE}) a list containing that data frame
   (\code{all_files}) and also data frames describing the hierarchy by given names (\code{hier_names}),
   directories (\code{hier_dirs}) and relative paths (\code{hier_paths}).
}
\description{
The function translates the hierarchy defintion given into a data frame with
one row for each file, including the generated document ID.
}
\examples{
myCorpusFiles <- corpus_files(
  dir=file.path(
    path.package("tm.plugin.koRpus"), "examples", "corpus"
  ),
  hierarchy=list(
    Topic=c(
      Winner="Reality Winner",
      Edwards="Natalie Edwards"
    ),
    Source=c(
      Wikipedia_prev="Wikipedia (old)",
      Wikipedia_new="Wikipedia (new)"
    )
  )
)
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
