% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_titrant.R
\name{ppt_titrant}
\alias{ppt_titrant}
\title{Precipitation Titration Curve: Monitoring pTitrant}
\usage{
ppt_titrant(conc.analyte = 0.025, conc.titrant = 0.05, vol.analyte = 50,
  pksp = 16.08, plot = TRUE, eqpt = FALSE, overlay = FALSE, ...)
}
\arguments{
\item{conc.analyte}{Molar concentration of the analyte; defaults to
0.025 M.}

\item{conc.titrant}{Molar concentration of the titrant; defaults to
0.050 M.}

\item{vol.analyte}{Initital volume, in mL, of the solution 
containing the analyte; defaults to 50.00 mL.}

\item{pksp}{The pKsp value for the precipitate; defaults to 16.08,
which is the pKsp for AgI.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pTitrant in the second column. 
Also produces a plot of the titration curve with options to display 
the equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the precipitation titration curve 
for an analyte and a titrant that form a precipitate with a 1:1
stoichiometry. The calculation uses a single master equation
that finds the volume of titrant needed to achieve a fixed 
concentration of titrant, expressed as pTitrant, as outlined in 
R. de Levie's \emph{Principles of Quantitative Chemical Analysis} 
(McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence point
ex14 = ppt_titrant(eqpt = TRUE)
head(ex14)

### Overlay titration curves using different pKsp values 
ppt_titrant(pksp = 16, eqpt = TRUE)
ppt_titrant(pksp = 14, overlay = TRUE)
ppt_titrant(pksp = 12, overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

