% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing.R
\name{plot.smoothing_fitsae}
\alias{plot.smoothing_fitsae}
\title{Plot Method for \code{smoothing_fitsae} Object}
\usage{
\method{plot}{smoothing_fitsae}(x, size = 2.5, alpha = 0.8, ...)
}
\arguments{
\item{x}{A \code{smoothing_fitsae} object.}

\item{size}{Aesthetic option denoting the size of scatterplots points, see \code{\link[ggplot2]{geom_point}} documentation.}

\item{alpha}{Aesthetic option denoting the opacity of scatterplots points, see \code{\link[ggplot2]{geom_point}} documentation.}

\item{...}{Currently unused.}
}
\value{
A \code{ggplot2} object.
}
\description{
The \code{plot()} method provides (a) the boxplot of variance estimates, when effective sample sizes are estimated through \code{kish} method; (b) a scatterplot of both original and smoothed estimates versus the area sample sizes, when variance smoothing is performed through methods \code{ols} and \code{gls}.
}
\examples{

library(tipsae)

# loading toy dataset
data("emilia_cs")

# perform smoothing procedure
smoo <- smoothing(emilia_cs, direct_estimates = "hcr", area_id = "id",
                  raw_variance = "vars", areas_sample_sizes = "n",
                  var_function = NULL, method = "ols")
plot(smoo)

}
\seealso{
\code{\link{smoothing}} to produce the input object.
}
