% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observed_bias_tbl.R
\name{observed_bias_tbl}
\alias{observed_bias_tbl}
\title{Create a data frame to assist with creating an observed bias plot}
\usage{
observed_bias_tbl(ps_mod, outcome_mod, drop_list = NULL)
}
\arguments{
\item{ps_mod}{Model object for the propensity score model}

\item{outcome_mod}{Model object for the outcome model}

\item{drop_list}{Named list of covariates or groups of covariates to drop if
\code{NULL}, will default to dropping each covariate one at a time.}
}
\value{
Data frame with the following columns:
\itemize{
\item \code{dropped}: The covariate or group of covariates that were dropped
\item \code{type}: Explanation of \code{dropped}, whether it refers to a single covariate (\code{covariate}) or a group of covariates (\code{group})
\item \code{ps_formula}: The new formula for the updated propensity score model
\item \code{outcome_formula}: The new formula for the updated outcome model
\item \code{ps_model}: The new model object for the updated propensity score model
\item \code{p}: The updated propensity score
}
}
\description{
Create a data frame to assist with creating an observed bias plot
}
\examples{
ps_mod <- glm(am ~ mpg + cyl + I(hp^2), data = mtcars)
outcome_mod <- lm(qsec ~ am + hp + disp + wt, data = mtcars)
observed_bias_tbl(
 ps_mod,
 outcome_mod,
 drop_list = list(
   group_one = c("mpg", "hp"),
   group_two = c("cyl", "wt")
   )
 )
}
