% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_tippy.R
\name{use_tippy_funcs}
\alias{use_tippy_funcs}
\alias{use_tippy}
\alias{call_tippy}
\alias{tippy_class}
\title{Use tippy}
\usage{
use_tippy()

call_tippy(target, ...)

tippy_class(class, ...)
}
\arguments{
\item{target}{Target element.}

\item{...}{Any option from \href{https://atomiks.github.io/tippyjs/#all-options}{the official documentation}.}

\item{class}{Class of elements to apply tooltip to.}
}
\description{
Dynamically use tippy.
}
\section{Functions}{

\itemize{
  \item{\code{use_tippy} Includes tippy.js in header.}
  \item{\code{call_tippy} call \code{tippy} on specific target element(s), place after elements to be targeted.}
}
}

\examples{
if(interactive()){
library(shiny)

shinyApp(
  ui = fluidPage(
    p("Some text", class = "tooltip"),
    p("Some text", class = "tooltip"),
    p("Some text", class = "tooltip"),
    p("Some text", class = "tooltip"),
    p("Some text", class = "tooltip"),
    p("Some text", class = "tooltip"),
    tippy_class("tooltip", content = "Hi!") # all elements with class
 ),
 server = function(input, output) {}
)
}

}
\seealso{
\href{https://atomiks.github.io/tippyjs/}{official documentation}
}
