% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tippy.R
\name{tippy_funcs}
\alias{tippy_funcs}
\alias{tippy}
\alias{tippy_this}
\alias{with_tippy}
\title{Create a tooltip}
\usage{
tippy(text, tooltip, ..., elementId = NULL)

tippy_this(elementId, tooltip, ...)

with_tippy(element, tooltip, ...)
}
\arguments{
\item{text}{Element text.}

\item{tooltip}{Element tooltip.}

\item{...}{Any other options from \href{https://atomiks.github.io/tippyjs/#all-options}{the official documentation}.}

\item{elementId}{\code{string} id as a valid \code{CSS} element id.}

\item{element}{An object of class \code{shiny.tag}.}
}
\description{
Add tooltips to your document.
}
\examples{
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!")
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!", placement = "right",
  theme = "light")
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!", animation = "scale",
  duration = 1000, placement = "bottom")
tippy("Click me!", tooltip = "Hi, I'm the tooltip!", trigger = "click",
  theme = "light")

# use tooltip on other elements.
if(interactive()){
library(shiny)

shinyApp(
  ui = fluidPage(
    with_tippy(textInput("input", "input with tooltip"), "Input text", placement = "right")
 ),
 server = function(input, output) {}
)
}

}
\seealso{
\href{https://atomiks.github.io/tippyjs/}{official documentation}
}
