% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{transfer_my_playback}
\alias{transfer_my_playback}
\title{Transfer playback to a new device and determine if it should start playing.}
\usage{
transfer_my_playback(
  device_ids,
  play = FALSE,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{device_ids}{Required. A character vector containing the ID of the device this on which playback should be started/transferred. Note: only a single device_id is currently supported.}

\item{play}{Optional. \cr
\code{TRUE}: Ensure playback happens on new device \cr
\code{FALSE} (default): keep the current playback state \cr
Note that a value of \code{FALSE} for the \code{play} parameter when also transferring to another \code{device_id} will not pause playback. To ensure that playback is paused on the new device you should send a pause command to the currently active device before transferring to the new \code{device_id}.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}. The access token must have been issued on behalf of the current user. \cr
The access token must have the \code{user-modify-playback-state} scope authorized in order to control playback.}
}
\value{
No return value.
}
\description{
Transfer playback to a new device and determine if it should start playing.
}
