% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_multi_deg_all.R
\name{multi_deg_all}
\alias{multi_deg_all}
\title{multi_deg_all}
\usage{
multi_deg_all(
  exp,
  group_list,
  ids,
  symmetry = TRUE,
  my_genes = NULL,
  show_rownames = FALSE,
  cluster_cols = TRUE,
  color_volcano = c("#2874C5", "grey", "#f87669"),
  pvalue_cutoff = 0.05,
  logFC_cutoff = 1,
  adjust = FALSE,
  entriz = TRUE,
  annotation_legend = FALSE,
  lab = NA,
  species = "human"
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{boolean specifying if column names are be shown.}

\item{cluster_cols}{boolean values determining if columns should be clustered or \code{hclust} object.}

\item{color_volcano}{color for volcano}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{entriz}{whether convert symbols to entriz ids}

\item{annotation_legend}{boolean value showing if the legend for annotation 
tracks should be drawn.}

\item{lab}{label for  x axis in volcano plot, if NA , x axis names by package}

\item{species}{choose human or mouse, or rat, default: human}
}
\value{
a list with deg data.frame, volcano plot and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\dontrun{
if(requireNamespace("Biobase",quietly = TRUE)&
   requireNamespace("AnnoProbe",quietly = TRUE)){
gse = "GSE474"
geo = geo_download(gse,destdir=tempdir())
geo$exp[1:4,1:4]
geo$exp=log2(geo$exp+1)
group_list=ifelse(stringr::str_detect(geo$pd$title,"MObese"),"MObese",
ifelse(stringr::str_detect(geo$pd$title,"NonObese"),"NonObese","Obese"))
group_list=factor(group_list,levels = c("NonObese","Obese","MObese"))
find_anno(geo$gpl)
ids = AnnoProbe::idmap(geo$gpl,destdir = tempdir())
dcp = multi_deg_all(geo$exp,
group_list,ids,adjust = FALSE,entriz = FALSE)
dcp[[3]]
}else{
  if(!requireNamespace("AnnoProbe",quietly = TRUE)) {
    warning("Package 'AnnoProbe' needed for this function to work.
         Please install it by install.packages('AnnoProbe')",call. = FALSE)
  }
  if(!requireNamespace("Biobase",quietly = TRUE)) {
    warning("Package 'Biobase' needed for this function to work.
         Please install it by BiocManager::install('Biobase')",call. = FALSE)
  }
}
}
}
\seealso{
\code{\link{geo_download}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
