% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{tintin_clrs}
\alias{tintin_clrs}
\title{Tintin Colour Palettes}
\usage{
tintin_clrs(
  n = 5,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus"
)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in \verb{[0,1]}, see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in \verb{[0,1]} at which the color map begins.}

\item{end}{The (corrected) hue in \verb{[0,1]} at which the color map ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Options are available with tidy names (i.e., 'the_blue_lotus'):
\describe{
\item{"Tintin in the Land of the Soviets"}{}
\item{"Tintin in the Congo"}{}
\item{"Tintin in America"}{}
\item{"Cigars of the Pharaoh"}{}
\item{"The Blue Lotus" (Standard)}{}
\item{"The Broken Ear"}{}
\item{"The Black Island"}{}
\item{"King Ottokar's Sceptre"}{}
\item{"The Crab with the Golden Claws"}{}
\item{"The Shooting Star"}{}
\item{"The Secret of the Unicorn"}{}
\item{"Red Rackham's Treasure"}{}
\item{"The Seven Crystal Balls"}{}
\item{"Prisoners of the Sun"}{}
\item{"Land of Black Gold"}{}
\item{"Destination Moon"}{}
\item{"Explorers on the Moon"}{}
\item{"The Calculus Affair"}{}
\item{"The Red Sea Sharks"}{}
\item{"Tintin in Tibet"}{}
\item{"The Castafiore Emerald"}{}
\item{"Flight 714 to Sydney"}{}
\item{"Tintin and the Picaros"}{}
\item{"Tintin and Alph-Art"}{}
}}
}
\value{
A \code{character} vector of colors.
}
\description{
This function creates a vector of colours along the selected
colour map.
}
\details{
Check the README for the display of the color palettes.
Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices (see \code{\link[grDevices]{rgb}}).
}
\examples{
# without extrapolation: 5 or fewer colors
n <- 5

tintin_clrs(n, option = "the_blue_lotus")

image(
  1:n, 1, as.matrix(1:n),
  col = tintin_clrs(n, option = "the_blue_lotus"),
  xlab = "Tintin darkblue n", ylab = "", xaxt = "n", yaxt = "n", bty = "n"
)

# with extrapolation: 6 or more colors
n <- 20
image(
  1:n, 1, as.matrix(1:n),
  col = tintin_clrs(n, option = "the_blue_lotus"),
  xlab = "Tintin darkblue n", ylab = "", xaxt = "n", yaxt = "n", bty = "n"
)

}
