% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setItems}
\alias{setItems}
\title{Set the items of a timeline}
\usage{
setItems(id, data)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{data}{A dataframe containing the item data to use.}
}
\description{
Set the items of a timeline
}
\examples{
\dontrun{
timevis(data.frame(start = Sys.Date(), content = "Today")) \%>\%
  setItems(data.frame(start = Sys.Date() - 1, content = "yesterday"))
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Change the data to yesterday")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis(data.frame(start = Sys.Date(), content = "Today"))
    )
    observeEvent(input$btn, {
      setItems("timeline",
               data.frame(start = Sys.Date() - 1, content = "yesterday"))
    })
  }
)
}
}
