% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_dataset_get_last_update}
\alias{db_dataset_get_last_update}
\title{Get the dataset last update}
\usage{
db_dataset_get_last_update(con, set_id, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{set_id}{\strong{character} name of the set to get the last update}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Get the dataset last update
}
\examples{

\dontrun{

# Storing different versions of the data, use parameter valid_from
# different versions are stored with the same key
ch.kof.barometer <- kof_ts["baro_2019m11"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2019-12-01",
  schema = "schema"
)

ch.kof.barometer <- kof_ts["baro_2019m12"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2020-01-01",
  schema = "schema"
)

db_dataset_create(
  con = connection,
  set_name = "barometer",
  set_description = "KOF Barometer",
  schema = "schema"
)

db_ts_assign_dataset(
  con = connection,
  ts_keys = "ch.kof.barometer",
  set_name = "barometer",
  schema = "schema"
)

db_dataset_get_last_update(
  con = connection,
  set_id = "barometer",
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_assign_dataset}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
