% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{db_connection_create}
\alias{db_connection_create}
\title{Create Database Connection}
\usage{
db_connection_create(
  dbname,
  user = Sys.info()[["user"]],
  host = "localhost",
  passwd = NULL,
  passwd_from_file = FALSE,
  line_no = 1,
  passwd_from_env = FALSE,
  connection_description = "timeseriesdb",
  port = 5432
)
}
\arguments{
\item{dbname}{character name of the database.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}

\item{host}{character denoting the hostname. Defaults to localhost.}

\item{passwd}{character password, file or environment name. Defaults to NULL triggering an R Studio function that
asks for your passwords interactively if you are on R Studio. Make sure to adapt the boolean params correspondingly.}

\item{passwd_from_file}{boolean if set to TRUE the passwd param is interpreted as a file
location for a password file such as .pgpass. Make sure to be very
restrictive with file permissions if you store a password to a file.}

\item{line_no}{integer specify line number of password file that holds the actual password.}

\item{passwd_from_env}{boolean if set to TRUE the passwd param is interpreted as the name of an
environment variable from which to get the password}

\item{connection_description}{character connection description describing the application
that connects to the database. This is mainly helpful for
DB admins and shows up in the pg_stat_activity table.
Defaults to 'timeseriesdb'. Avoid spaces as this is a psql option.}

\item{port}{integer defaults to 5432, the PostgreSQL standard port.}
}
\description{
Connects to the PostgreSQL database backend of timeseriesdb. This function
is convenience wrapper around DBI's dbConnect. It's less general than the DBI
function and only works for PostgreSQL, but it is a little more convenient
because of its defaults / assumptions.
}
