% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AalenJohansen.R
\name{AalenJohansen}
\alias{AalenJohansen}
\title{Risk estimate using the Aalen-Johansen method}
\usage{
AalenJohansen(
  time,
  cause,
  t,
  risk.H0 = NULL,
  level = 0.95,
  contr = list(tol = 1e-05, k = 3, Trace = FALSE, method = "both")
)
}
\arguments{
\item{time}{vector of times (possibly censored)}

\item{cause}{vector of event types/causes. It should be coded 1 for main events, 2 for competing events and 0 for censored.}

\item{t}{the time point of interest (e.g., 1 to compute a 1-year risk)}

\item{risk.H0}{risk under the null hypothesis, if one would like to compute the correspondng p-value. Default is NULL, for which no p-value is computed.}

\item{level}{confidence level for the confidence intervals. Default is 0.95.}

\item{contr}{list of control parameters. tol=tolerance for numerical computation, default is 1e-5. method="EL", "Wald" or "both"  indicates wether 95\% CI and p-value should be computed based on Empirical Likelihood (EL) inference , Wald-type inference or both.}
}
\value{
object of class 'AalenJohansen'
}
\description{
Computes the Aalen-Johansen estimator to estimate an (absolute) risk
with right-censored competing risks data, together with a confidence interval and (possibly) a
p-value (for a one-sample hypothesis test). Computation of confidence intervals
and p-values is based on either Empirical Likelihood (EL) inference
or Wald-type inference. Both are non-parametric approaches, which are asymptotically equivalent.
See Blanche (2020) for details. For the Wald-type approach, the asymptotic normal approximation is used on the cloglog scale. See e.g. equation 4.21 in Beyersmann et al (2011).
}
\examples{
x <- AalenJohansen(time=melanoma5$time, cause=melanoma5$status, t=4, level=0.95)
x

}
\references{
Blanche, P. (2020). Confidence intervals for the cumulative incidence function via constrained NPMLE. Lifetime Data Analysis, 26(1), 45-64.

Beyersmann, Allignol,  & Schumacher (2011). Competing risks and multistate models with R. Springer Science & Business Media.
}
\author{
Paul Blanche
}
