% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-long-SpatVector.R
\name{pivot_longer.SpatVector}
\alias{pivot_longer.SpatVector}
\title{Pivot \code{SpatVector} from wide to long}
\usage{
\method{pivot_longer}{SpatVector}(
  data,
  cols,
  ...,
  cols_vary = "fastest",
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL
)
}
\arguments{
\item{data}{A \code{SpatVector} to pivot.}

\item{cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to pivot into
longer format.}

\item{...}{Additional arguments passed on to methods.}

\item{cols_vary}{When pivoting \code{cols} into longer format, how should the
output rows be arranged relative to their original row number?
\itemize{
\item \code{"fastest"}, the default, keeps individual rows from \code{cols} close
together in the output. This often produces intuitively ordered output
when you have at least one key column from \code{data} that is not involved in
the pivoting process.
\item \code{"slowest"} keeps individual columns from \code{cols} close together in the
output. This often produces intuitively ordered output when you utilize
all of the columns from \code{data} in the pivoting process.
}}

\item{names_to}{A character vector specifying the new column or columns to
create from the information stored in the column names of \code{data} specified
by \code{cols}.
\itemize{
\item If length 0, or if \code{NULL} is supplied, no columns will be created.
\item If length 1, a single column will be created which will contain the
column names specified by \code{cols}.
\item If length >1, multiple columns will be created. In this case, one of
\code{names_sep} or \code{names_pattern} must be supplied to specify how the
column names should be split. There are also two additional character
values you can take advantage of:
\itemize{
\item \code{NA} will discard the corresponding component of the column name.
\item \code{".value"} indicates that the corresponding component of the column
name defines the name of the output column containing the cell values,
overriding \code{values_to} entirely.
}
}}

\item{names_prefix}{A regular expression used to remove matching text
from the start of each variable name.}

\item{names_sep, names_pattern}{If \code{names_to} contains multiple values,
these arguments control how the column name is broken up.

\code{names_sep} takes the same specification as \code{\link[tidyr:separate]{separate()}}, and can either
be a numeric vector (specifying positions to break on), or a single string
(specifying a regular expression to split on).

\code{names_pattern} takes the same specification as \code{\link[tidyr:extract]{extract()}}, a regular
expression containing matching groups (\verb{()}).

If these arguments do not give you enough control, use
\code{pivot_longer_spec()} to create a spec object and process manually as
needed.}

\item{names_ptypes, values_ptypes}{Optionally, a list of column name-prototype
pairs. Alternatively, a single empty prototype can be supplied, which will
be applied to all columns. A prototype (or ptype for short) is a
zero-length vector (like \code{integer()} or \code{numeric()}) that defines the type,
class, and attributes of a vector. Use these arguments if you want to
confirm that the created columns are the types that you expect. Note that
if you want to change (instead of confirm) the types of specific columns,
you should use \code{names_transform} or \code{values_transform} instead.}

\item{names_transform, values_transform}{Optionally, a list of column
name-function pairs. Alternatively, a single function can be supplied,
which will be applied to all columns. Use these arguments if you need to
change the types of specific columns. For example, \code{names_transform = list(week = as.integer)} would convert a character variable called \code{week}
to an integer.

If not specified, the type of the columns generated from \code{names_to} will
be character, and the type of the variables generated from \code{values_to}
will be the common type of the input columns used to generate them.}

\item{names_repair}{What happens if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{values_to}{A string specifying the name of the column to create
from the data stored in cell values. If \code{names_to} is a character
containing the special \code{.value} sentinel, this value will be ignored,
and the name of the value column will be derived from part of the
existing column names.}

\item{values_drop_na}{If \code{TRUE}, will drop rows that contain only \code{NA}s
in the \code{value_to} column. This effectively converts explicit missing values
to implicit missing values, and should generally be used only when missing
values in \code{data} were created by its structure.}
}
\value{
A \code{SpatVector} object.
}
\description{
\code{pivot_longer()} "lengthens" data, increasing the number of rows and
decreasing the number of columns. The inverse transformation is
\code{\link[=pivot_wider.SpatVector]{pivot_wider.SpatVector()}}

Learn more in \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}} function.
\subsection{\code{SpatVector}}{

The geometry column has a sticky behavior. This means that the result would
have always the geometry of \code{data}.
}
}

\examples{
\donttest{

library(dplyr)
library(tidyr)
library(ggplot2)
library(terra)

temp <- rast((system.file("extdata/cyl_temp.tif", package = "tidyterra")))
cyl <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra")) \%>\%
  project(temp)

# Add average temp

temps <- terra::extract(temp, cyl, fun = "mean", na.rm = TRUE, xy = TRUE)
cyl_temp <- cbind(cyl, temps) \%>\%
  glimpse()

# And pivot long for plot
cyl_temp \%>\%
  pivot_longer(
    cols = tavg_04:tavg_06,
    names_to = "label",
    values_to = "temp"
  ) \%>\%
  ggplot() +
  geom_spatvector(aes(fill = temp)) +
  facet_wrap(~label, ncol = 1) +
  scale_fill_whitebox_c(palette = "muted")
}
}
\seealso{
\code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}

Other \CRANpkg{tidyr} verbs for pivoting:
\code{\link{pivot_wider.SpatVector}()}

Other \CRANpkg{tidyr} methods:
\code{\link{drop_na.Spat}},
\code{\link{fill.SpatVector}()},
\code{\link{pivot_wider.SpatVector}()},
\code{\link{replace_na.Spat}}
}
\concept{tidyr.methods}
\concept{tidyr.pivot}
