% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_mspe_ratio}
\alias{plot_mspe_ratio}
\title{plot_mspe_ratio}
\usage{
plot_mspe_ratio(data, time_window = NULL)
}
\arguments{
\item{data}{nested data of type \code{tbl_df}.}

\item{time_window}{time window that the pre- and post-period values should be
used to compute the MSPE ratio.}
}
\value{
\code{ggplot} object plotting the MSPE ratios by case.
}
\description{
Plot the MSPE ratios for each case (observed and placebos). The ratio is used
for inference in the synthetic control setup. The following plot ranks the
RMSE ratio's in descending order.
}
\details{
Inferential statitics are generated by comparing the observed difference
between the actual treated unit and its synthetic control to each placebo
unit and its synthetic control. The rarity of the actual to the placebo is
used to infer the likelihood of observing the effect.

Inference in this framework leverages the mean squared predictive error
(MSPE) of the fit in the pre-period to the fit in the post-period as a ratio.

\deqn{\frac{RMSE_{Post}}{RMSE_{Pre}}}

The ratio captures the differences between the pre-intervention fit and the
post-intervention divergence of the trend (i.e. the causal quantity). A good
fit in the pre-period denotes that the observed and synthetic case tracked
well together. Divergence in the post-period captures the difference brought
about by the intervention in the two trends. Thus, when the ratio is high, we
observe more of a difference between the two trends. If, however, the
pre-period fit is poor, or there is not substantial divergence in the
post-period, then this ratio amount will be smaller. A more detailed outline
of inference within the synthetic control framework can be found in Adabie et
al. 2010.
}
\examples{

\donttest{

# Smoking example data
data(smoking)

smoking_out <-
smoking \%>\%

# initial the synthetic control object
synthetic_control(outcome = cigsale,
                  unit = state,
                  time = year,
                  i_unit = "California",
                  i_time = 1988,
                  generate_placebos=TRUE) \%>\%

# Generate the aggregate predictors used to generate the weights
  generate_predictor(time_window=1980:1988,
                     lnincome = mean(lnincome, na.rm = TRUE),
                     retprice = mean(retprice, na.rm = TRUE),
                     age15to24 = mean(age15to24, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1984:1988,
                     beer = mean(beer, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1975,
                     cigsale_1975 = cigsale) \%>\%

  generate_predictor(time_window=1980,
                     cigsale_1980 = cigsale) \%>\%

  generate_predictor(time_window=1988,
                     cigsale_1988 = cigsale) \%>\%


  # Generate the fitted weights for the synthetic control
  generate_weights(optimization_window =1970:1988,
                   Margin.ipop=.02,Sigf.ipop=7,Bound.ipop=6) \%>\%

  # Generate the synthetic control
  generate_control()

# Plot the observed and synthetic trend
smoking_out \%>\% plot_mspe_ratio(time_window = 1970:2000)

}

}
