% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse.R
\name{reverse}
\alias{reverse}
\alias{reverse.sq}
\title{Reverse sequence}
\usage{
reverse(x, ...)

\method{reverse}{sq}(x, ..., NA_letter = getOption("tidysq_NA_letter"))
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
An \code{\link[=sq-class]{sq}} object of the same type as input
object but each sequence is reversed.
}
\description{
Reverse given list of sequences.
}
\details{
\code{reverse()} function reverses each sequence in supplied \code{sq} object
(e.q. transforms \code{"MIAANYTWIL"} to \code{"LIWTYNAAIM"}). This operation
does not alter the type of the input object nor its alphabet.
}
\examples{
# Creating objects to work on:
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_dna <- sq(c("ATGCAGGA", "GACCGAACGAN", ""), alphabet = "dna_ext")
sq_unt <- sq(c("ATGCAGGA?", "TGACGAGCTTA", "", "TIAALGNIIYRAIE"))

# Reversing sequences:
reverse(sq_ami)
reverse(sq_dna)
reverse(sq_unt)

}
\seealso{
Functions that affect order of elements:
\code{\link{bite}()},
\code{\link{collapse}()},
\code{\link{paste}()}
}
\concept{order_functions}
