% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_sub.R
\name{repeat_sub}
\alias{repeat_sub}
\title{Repeat table subheadings}
\usage{
repeat_sub(x, column = "subheading", first = TRUE)
}
\arguments{
\item{x}{a tibble with subheadings}

\item{column}{new column name, default subheading}

\item{first}{add subheader as first column, default TRUE}
}
\value{
a tibble
}
\description{
Repeat table subheadings in a new column
}
\details{
Identifies subheadings in a data frame by checking for rows with a non-empty
first column and all other columns are empty. Removes subheader rows and
repeats values down a new column.
}
\examples{
x <- data.frame(
  genes = c("Up", "aroB", "glnP", "Down", "ndhA", "pyrF"),
  fold_change = c(NA, 2.5, 1.7, NA, -3.1, -2.6)
)
x
repeat_sub(x)
repeat_sub(x, "regulated", first = FALSE)
}
\author{
Chris Stubben
}
