% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{tidyplots_options}
\alias{tidyplots_options}
\title{Tidyplots options}
\usage{
tidyplots_options(
  width = NULL,
  height = NULL,
  unit = NULL,
  dodge_width = NULL,
  my_style = NULL
)
}
\arguments{
\item{width}{Width of the plot area. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{50}.}

\item{height}{Height of the plot area. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{50}.}

\item{unit}{Unit of the plot area width and height. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{"mm"}.}

\item{dodge_width}{For adjusting the distance between grouped objects.
The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which defaults to \code{0.8} for plots with
at least one discrete axis and to \code{0} for plots with two continuous axes.}

\item{my_style}{Styling function to apply to the plot. The default (\code{NULL}) retrieves the setting from the
\link[=tidyplots_options]{tidyplots options}, which default to no additional styling.}
}
\value{
The old options invisibly
}
\description{
Control the settings for formatting tidyplots globally.
}
\examples{

# Define custom style
my_style <- function(x) x |>
  adjust_colors(colors_discrete_candy) |>
  adjust_font(family = "mono")

# Set tidyplots options
tidyplots_options(
  width = 3,
  height = 4,
  unit = "cm",
  dodge_width = 1,
  my_style = my_style
  )

# Plot
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_mean_bar()

# Reset tidyplots options
tidyplots_options()

# Same plot
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_mean_bar()

}
