% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-annotation.R
\name{add_data_labels}
\alias{add_data_labels}
\alias{add_data_labels_repel}
\title{Add data labels}
\usage{
add_data_labels(
  plot,
  label,
  data = all_rows(),
  fontsize = 7,
  dodge_width = NULL,
  jitter_width = 0,
  jitter_height = 0,
  preserve = "total",
  background = FALSE,
  background_color = "#FFFFFF",
  background_alpha = 0.6,
  label_position = c("below", "above", "left", "right", "center"),
  ...
)

add_data_labels_repel(
  plot,
  label,
  data = all_rows(),
  fontsize = 7,
  dodge_width = NULL,
  jitter_width = 0,
  jitter_height = 0,
  preserve = "total",
  segment.size = 0.2,
  box.padding = 0.2,
  max.overlaps = Inf,
  background = FALSE,
  background_color = "#FFFFFF",
  background_alpha = 0.6,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{label}{Variable in the dataset to be used for the text label.}

\item{data}{The data to be displayed in this layer. There are three options:
\itemize{
\item If \code{all_rows()} (the default) the complete dataset is displayed.
\item A \code{function} to subset the plot data. See \code{filter_rows()} and friends.
\item A \code{data.frame} to override the plot data.
}}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{jitter_width}{Amount of random noise to be added to the
horizontal position of the of the data points. This can be useful to deal
with overplotting. Typical values range between \code{0} and \code{1}.}

\item{jitter_height}{Amount of random noise to be added to the
vertical position of the of the data points. This can be useful to deal
with overplotting. Typical values range between \code{0} and \code{1}.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{background}{Whether to include semitransparent background box behind the labels to improve legibility. Defaults to \code{FALSE}.}

\item{background_color}{Hex color of the background box. Defaults to \code{"#FFFFFF"} for white.}

\item{background_alpha}{Opacity of the background box. Defaults to \code{0.6}.}

\item{label_position}{Position of the label in relation to the data point. Can be one of \code{c("below", "above", "left", "right", "center")}.}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{segment.size}{Thickness of the line connecting the label with the data point. Defaults to \code{0.2}.}

\item{box.padding}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{max.overlaps}{Exclude text labels when they overlap too many other
things. For each text label, we count how many other text labels or other
data points it overlaps, and exclude the text label if it has too many overlaps.
Defaults to 10.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add data labels
}
\details{
\itemize{
\item \code{add_data_labels_repel()} uses \code{ggrepel::geom_text_repel()}. Check there
and in \href{https://ggrepel.slowkow.com/articles/examples}{ggrepel examples} for
additional arguments.
\item \code{add_data_labels()} and \code{add_data_labels_repel()} support data subsetting. See \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#data-subsetting}{Advanced plotting}.
}
}
\examples{
# Create plot and increase padding to make more space for labels
p <-
  animals |>
  dplyr::slice_head(n = 5) |>
  tidyplot(x = weight, y = speed) |>
  theme_ggplot2() |>
  add_data_points() |>
  adjust_padding(all = 0.3)

# Default label position is `below` the data point
p |> add_data_labels(label = animal)

# Alternative label positions
p |> add_data_labels(label = animal, label_position = "above")

p |> add_data_labels(label = animal, label_position = "right")

p |> add_data_labels(label = animal, label_position = "left")

# Include white background box
p |> add_data_labels(label = animal, background = TRUE)

p |> add_data_labels(label = animal, background = TRUE,
  background_color = "pink")

# Black labels
p |> add_data_labels(label = animal, color = "black")

# Use repelling data labels
p |> add_data_labels_repel(label = animal, color = "black")

p |> add_data_labels_repel(label = animal, color = "black",
  background = TRUE)

p |> add_data_labels_repel(label = animal, color = "black",
  background = TRUE, min.segment.length = 0)

}
