% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{genome_complement}
\alias{genome_complement}
\title{Calculates the complement to the intervals covered by the intervals in
a data frame. It can optionally take a \code{chromosome_size} data frame
that contains 2 or 3 columns, the first the names of chromosome and in case
there are 2 columns the size or first the start index and lastly the end index
on the chromosome.}
\usage{
genome_complement(x, chromosome_size = NULL, by = NULL)
}
\arguments{
\item{x}{A data frame for which the complement is calculated}

\item{chromosome_size}{A dataframe with at least 2 columns that contains
first the chromosome name and then the size of that chromosome. Can be NULL
in which case the largest value per chromosome from \code{x} is used.}

\item{by}{A character vector with 3 entries which are the chromosome, start and end column.
For example: \code{by=c("chr", "start", "end")}}
}
\description{
Calculates the complement to the intervals covered by the intervals in
a data frame. It can optionally take a \code{chromosome_size} data frame
that contains 2 or 3 columns, the first the names of chromosome and in case
there are 2 columns the size or first the start index and lastly the end index
on the chromosome.
}
\examples{

library(dplyr)

x1 <- data.frame(id = 1:4, bla=letters[1:4],
                 chromosome = c("chr1", "chr1", "chr2", "chr1"),
                 start = c(100, 200, 300, 400),
                 end = c(150, 250, 350, 450))

genome_complement(x1, by=c("chromosome", "start", "end"))
}
