% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice-formula.R
\name{roll_dice_formula}
\alias{roll_dice_formula}
\title{Simulating rolling a dice, using a formula}
\usage{
roll_dice_formula(
  data = NULL,
  dice_formula = "1d6",
  times = 1,
  rounds = 1,
  seed = NULL,
  prob = NULL,
  success = c(6),
  agg = FALSE,
  label = NULL
)
}
\arguments{
\item{data}{Data from a previous experiment}

\item{dice_formula}{Dice formula (e.g. "1d6" = 1 dice with 6 sides)}

\item{times}{How many times a dice is rolled (or how many dice are rolled at the same time)}

\item{rounds}{Number of rounds}

\item{seed}{Seed to produce reproducible results}

\item{prob}{Vector of probabilities for each side of the dice}

\item{success}{Which result is a success (default = 6)}

\item{agg}{If TRUE, the result is aggregated (by experiment, rounds) (not implemented)}

\item{label}{Custom text to distinguish an experiment, can be used for plotting etc.}
}
\value{
Result of experiment as a tibble
}
\description{
Simulating rolling a dice, using a formula
}
\examples{
# roll one 6-sided dice
roll_dice_formula(dice_formula = "1d6")

# roll one 8-sided dice
roll_dice_formula(dice_formula = "1d8")

# roll two 6-sided dice
roll_dice_formula(dice_formula = "2d6")

# roll two 6-sided dice, explode dice on a 6
roll_dice_formula(dice_formula = "2d6e6")

# roll three 6-sided dice, keep highest 2 rolls
roll_dice_formula(dice_formula = "3d6kh2")

# roll three 6-sided dice, keep lowest 2 rolls
roll_dice_formula(dice_formula = "3d6kl2")

# roll four 6-sided dice, keep highest 3 rolls, but explode on a 6
roll_dice_formula(dice_formula = "4d6kh3e6")

# roll one 20-sided dice, and add 4
roll_dice_formula(dice_formula = "1d20+4")

# roll one 4-sided dice and one 6-sided dice, and sum the results
roll_dice_formula(dice_formula = "1d4+1d6")
}
