% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_kurtosis.R
\name{summarise_kurtosis}
\alias{summarise_kurtosis}
\title{Summarise Kurtosis}
\usage{
summarise_kurtosis(x, method = c("standard", "unbiased"), excess = TRUE)
}
\arguments{
\item{x}{A numeric vector, matrix, data frame, or tibble.}

\item{method}{Character. Method for kurtosis calculation: `"standard"` (default) or `"unbiased"`.}

\item{excess}{Logical. If TRUE (default), returns **excess kurtosis** (minus 3); if FALSE, returns **raw kurtosis**.}
}
\value{
A tibble:
- If input has one numeric column (or is a vector), a single-row tibble.
- If input has multiple numeric columns, a tibble with variable names and kurtosis values.
}
\description{
Calculates the kurtosis (default: **excess kurtosis**) of numeric vectors, matrices, data frames, or tibbles.
Supports both the "standard" and "unbiased" methods and optionally returns **raw kurtosis**.
}
\examples{
summarise_kurtosis(iris)
summarise_kurtosis(iris, method = "unbiased")
summarise_kurtosis(iris, excess = FALSE)  # Raw kurtosis
summarise_kurtosis(iris$Sepal.Width)

}
