% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_replace_many.R
\name{str_replace_many}
\alias{str_replace_many}
\title{Multiple Pattern-Replacement Substitutions}
\usage{
str_replace_many(x, pattern, replacement, column = NULL, ...)
}
\arguments{
\item{x}{A character vector or a data frame containing the text to modify.}

\item{pattern}{A character vector of regular expressions to match.}

\item{replacement}{A character vector of replacement strings, same length as `pattern`.}

\item{column}{Optional. If `x` is a data frame, the name of the character column to apply the replacements to.}

\item{...}{Additional arguments passed to `gsub()`, such as `ignore.case = TRUE`.}
}
\value{
- If `x` is a character vector, returns a modified character vector.
- If `x` is a data frame, returns the data frame with the specified column modified.
}
\description{
Applies multiple regular expression substitutions to a character vector or a specific column of a data frame. 
Performs replacements sequentially
}
\examples{
# Example on a character vector
text <- c("The cat and the dog", "dog runs fast", "no animals")
str_replace_many(text, pattern = c("cat", "dog"), replacement = c("lion", "wolf"))

# Example on a data frame
library(tibble)
df <- tibble(id = 1:3, text = c("The cat sleeps", "dog runs fast", "no pets"))
str_replace_many(df, pattern = c("cat", "dog"), replacement = c("lion", "wolf"), column = "text")

}
