% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-solutions.R
\name{compare_solutions}
\alias{compare_solutions}
\title{Compare latent profile models}
\usage{
compare_solutions(x, statistics = "BIC")
}
\arguments{
\item{x}{An object of class 'tidyLPA'.}

\item{statistics}{Character vector. Which statistics to examine for
determining the optimal model. Defaults to 'BIC'.}
}
\value{
An object of class 'bestLPA' and 'list', containing a tibble of fits
'fits', a named vector 'best', indicating which model fit best according to
each fit index, a numeric vector 'AHP' indicating the best model according to
the \code{\link{AHP}}, an object 'plot' of class 'ggplot', and a numeric
vector 'statistics' corresponding to argument of the same name.
}
\description{
Takes an object of class 'tidyLPA', containing multiple latent profile models
with different number of classes or model specifications, and helps select
the optimal number of classes and model specification.
}
\examples{
iris_subset <- sample(nrow(iris), 20) # so examples execute quickly
results <- iris \%>\%
  subset(select = c("Sepal.Length", "Sepal.Width",
    "Petal.Length", "Petal.Width")) \%>\%
  estimate_profiles(1:3) \%>\%
  compare_solutions()
}
\author{
Caspar J. van Lissa
}
