% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{set_blocks_from_df}
\alias{set_blocks_from_df}
\title{Prepare blocks of items from a data frame}
\usage{
set_blocks_from_df(
  data,
  blocks = "block",
  items = "item",
  traits = "trait",
  names = items,
  signs = "sign"
)
}
\arguments{
\item{data}{A \code{data.frame} containing all the required columns
(see the arguments below) to specify the item blocks.}

\item{blocks}{Name of column vector denoting the block each item
corresponds to. Each block must have an equal number of items.}

\item{items}{Name of column vector denoting items to be combined into
one block. Should correspond to variables in the data.}

\item{traits}{Names of column vector denoting the traits to which each
item belongs.}

\item{names}{Optional column vector of item names in the output.
Can be used to equate parameters of items across blocks,
if the same item was used in different blocks.}

\item{signs}{Name of column vector with expected signs of the
item loadings (1 or -1).}
}
\description{
Prepare blocks of items and incorporate information
about which item belongs to which trait from a pre-existing dataframe.
This is a wrapper function for \code{\link{set_block}}, eliminating the need
to manually set each item, trait, name and sign (loading) info per block.
}
\details{
A block of items is a set of two or more items presented and answered
together by fully ranking them or selecting the most and/or least favorite
in a forced choice format. A whole test usually contains
several blocks and items may reappear in different blocks.
}
\examples{
block_info <- data.frame(
  block = rep(1:4, each = 3),
  items = c("i1", "i2", "i3", "i4", "i5", "i6",
            "i7", "i8", "i9", "i10", "i11", "i12"),
  traits = rep(c("t1", "t2", "t3"), times = 4),
  signs = c(1, 1, 1, -1, 1, 1, 1, 1, -1, 1, -1, 1)
)

blocks <- set_blocks_from_df(
  data = block_info,
  blocks = "block",
  items = "items",
  traits = "traits",
  signs = "signs"
)

}
\seealso{
\code{\link{set_block}}
}
