% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan.R
\name{fit_TIRT_lavaan}
\alias{fit_TIRT_lavaan}
\title{Fit Thurstonian IRT models in lavaan}
\usage{
fit_TIRT_lavaan(data, estimator = "ULSMV", ...)
}
\arguments{
\item{data}{An object of class \code{'TIRTdata'}. see
\code{\link{make_TIRT_data}} for documentation on how to create one.}

\item{estimator}{Name of the estimator that should be used.
See \code{\link[lavaan:lavOptions]{lavOptions}}.}

\item{...}{Further arguments passed to
\code{\link[lavaan:lavaan]{lavaan}}.}
}
\value{
A \code{'TIRTfit'} object.
}
\description{
Fit Thurstonian IRT models in lavaan
}
\examples{
# load the data
data("triplets")

# define the blocks of items
blocks <-
  set_block(c("i1", "i2", "i3"), traits = c("t1", "t2", "t3"),
          signs = c(1, 1, 1)) +
  set_block(c("i4", "i5", "i6"), traits = c("t1", "t2", "t3"),
            signs = c(-1, 1, 1)) +
  set_block(c("i7", "i8", "i9"), traits = c("t1", "t2", "t3"),
            signs = c(1, 1, -1)) +
  set_block(c("i10", "i11", "i12"), traits = c("t1", "t2", "t3"),
            signs = c(1, -1, 1))

# generate the data to be understood by 'thurstonianIRT'
triplets_long <- make_TIRT_data(
  data = triplets, blocks = blocks, direction = "larger",
  format = "pairwise", family = "bernoulli", range = c(0, 1)
)

\donttest{
# fit the data using lavaan
fit <- fit_TIRT_lavaan(triplets_long)
print(fit)
predict(fit)
}

}
