% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_par_cor.R
\name{bound_par_cor}
\alias{bound_par_cor}
\title{Bounded parameter correction}
\usage{
bound_par_cor(theta_hat, sigma_svd, bound, radius, n_simuls = 1e+05)
}
\arguments{
\item{theta_hat}{center of the ellipsoid A.}

\item{sigma_svd}{Singular value decomposition (SVD) of the posterior
covariance matrix used to define A.}

\item{bound}{Function calculating membership of a point in the posterior support.}

\item{radius}{positive number, radius determining the ellipsoid A}

\item{n_simuls}{Integer, number of Monte Carlo simulations to use in the calculation.}
}
\value{
A number in [0,1] estimating of the proportion of the volume of A
    contained in the posterior support.
}
\description{
Computes Monte Carlo estimate of the bounded parameter correction to THAMES
}
\examples{
theta_ext <- runif(100)
theta_ins <- runif(100) / 100
}
\keyword{internal}
