% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer.R
\name{transfer}
\alias{transfer}
\title{Glass Transfer, Persistence and Recovery Probabilities}
\usage{
transfer(
  N = 10000,
  d = 0.5,
  deffect = TRUE,
  lambda = 120,
  Q = 0.05,
  l0 = 0.8,
  u0 = 0.9,
  lstar0 = 0.1,
  ustar0 = 0.15,
  lj = 0.45,
  uj = 0.7,
  lstarj = 0.05,
  ustarj = 0.1,
  lR = 0.5,
  uR = 0.7,
  lt = 1,
  ut = 2,
  r = 0.5,
  timeDist = c("negbin", "cnegbin", "uniform"),
  loop = FALSE
)
}
\arguments{
\item{N}{Simulation size}

\item{d}{The breaker's distance from the window}

\item{deffect}{Distance effect. \code{deffect = TRUE} when distance effect
exists. Otherwise \code{deffect = FALSE}.}

\item{lambda}{The average number of glass fragments transferred to the
breaker's clothing.}

\item{Q}{Proportion of high persistence fragments.}

\item{l0}{Lower bound on the percentage of fragments lost in the first hour}

\item{u0}{Upper bound on the percentage of fragments lost in the first hour}

\item{lstar0}{Lower bound on the percentage of high persistence fragments
lost in the first hour}

\item{ustar0}{Upper bound on the percentage of high persistence fragments
lost in the first hour}

\item{lj}{Lower bound on the percentage of fragments lost in the j'th hour}

\item{uj}{Upper bound on the percentage of fragments lost in the j'th hour}

\item{lstarj}{Lower bound on the percentage of high persistence fragments
lost in the j'th hour}

\item{ustarj}{Upper bound on the percentage of high persistence fragments
lost in the j'th hour}

\item{lR}{Lower bound on the percentage of fragments expected to be detected
in the lab}

\item{uR}{Upper bound on the percentage of fragments expected to be detected
in the lab}

\item{lt}{Lower bound on time between commission of crime and apprehension of suspect}

\item{ut}{Upper bound on time between commission of crime and apprehension of suspect}

\item{r}{Probability r in ti ~ NegBinom(t, r)}

\item{timeDist}{the distribution for the random amount of time between the commission of
the crime and the apprehension of the suspect. There are three choices \code{"negbin"},
\code{"cnegbin"}, and \code{"uniform"}. Before talking about these it should be noted that
if \code{lt} is equal to \code{ut} - then there is no randomness in this calculation. If
\code{lt} does not equal \code{ut}, then the average of these two values is used in the
two negative binomial options: \code{"negbin"} and \code{"cnegbin"}. The difference betweeen
them is that \code{"cnegbin"} is a constrained negative binomial where the allowable times are
constrained to be between \code{lt} and \code{ut}. If \code{"uniform"} is selected, then
a uniformly distributed random time between \code{lt} and \code{ut} is used in each iteration.}

\item{loop}{if \code{TRUE} an element by element version of the simulation is used,
if \code{FALSE} then a (mostly) vectorised element version of the simulation is used. 
The results from the two methods appear to be almost identical - they won't be the 
same even with the same seed because of the way the random variates are generated. I
(James) believe the vectorised version is faster and better. There was also a small mistake
which has been corrected in that the initial set of persistent fragments was not
being}
}
\value{
a \code{list} containing:
\describe{
  \item{results}{The simulated values of recovered glass fragments}
  \item{paramList}{Input parameters}
}
The returned object has S3 class types tfer and transfer for backwards compatibility
}
\description{
Construct a transfer object to simulate the number of glass fragments
recovered given the conditions set by the user.
}
\examples{

library(tfer)

## create a transfer object using default arguments
y = transfer()

## probability table
probs = tprob(y)

## extract the probabilities of recovering 8 to 15
## glass fragments given the user-specified arguments
tprob(y, 8:15)

## produce a summary table for a transfer object
summary(y)

## barplot of probabilities (default)
plot(y)
plot(y)

## barplot of transfer frequencies
plot(y, ptype = "f")

## histogram
plot(y, ptype = "h")

}
\references{
Curran, J. M., Hicks, T. N. & Buckleton, J. S. (2000).
  \emph{Forensic interpretation of glass evidence}. Boca Raton, FL: CRC
  Press.

  Curran, J. M., Triggs, C. M., Buckleton, J. S., Walsh, K. A. J. & Hicks T.
  N. (January, 1998). Assessing transfer probabilities in a Bayesian
  interpretation of forensic glass evidence. \emph{Science & Justice},
  \emph{38}(1), 15-21.
}
\author{
James Curran and TingYu Huang
}
