% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R
\name{lagpol}
\alias{lagpol}
\title{Lag polynomials}
\usage{
lagpol(param = NULL, s = 1, p = 1, lags = NULL, coef = NULL)
}
\arguments{
\item{param}{a vector/list of named parameters. These parameters can be used 
within the coefficient expressions.}

\item{s}{an integer specifying the lag spacing or seasonal period.}

\item{p}{an integer specifying the exponent applied to the base lag polynomial.}

\item{lags}{an optional vector of lags for sparse polynomials. If \code{NULL},
lags are determined by \code{s}.}

\item{coef}{an optional vector of mathematical expressions defining the 
coefficients of the lag polynomial. If \code{NULL}, the names in \code{param} 
are used.}
}
\value{
\code{lagpol} An object of class `lagpol` with the following
  components:
\describe{   
  \item{\code{coef}}{vector of coefficients c(coef_1, ..., coef_p) provided to 
  create the lag polynomial.}
  \item{\code{pol}}{base lag polynomial vector: 
  \eqn{1 - \text{coef}_1 B^s - \dots - \text{coef}_d B^{sd}}.}
  \item{\code{Pol}}{lag polynomial raised to the power `p`. 
  If `p = 1`, this equals `pol`.}
  }
}
\description{
\code{lagpol} creates a lag polynomial of the form: 
\deqn{(1 - coef_1 B^s - ... - coef_d B^{sd})^p}
This class of lag polynomials is defined by:
\itemize{
\item the base lag polynomial \eqn{1 - coef_1 B^s - ... - coef_d B^{sd}},
\item the exponent `p` of the base lag polynomial (default is `p = 1`),
\item the spacing parameter `s` in sparse lag polynomials 
(default is `s = 1`),
\item the vector of `d` coefficients `c(coef_1, ..., coef_d)`, which can be 
 mathematical expresions dependent on `k` parameters 
 `c(param_1, ..., param_k)`.
 }
}
\examples{
# Simple AR(1) lag polynomial: 1 - 0.8B
lagpol(param = c(phi = 0.8))

# AR(2) lag polynomial with seasonal lag s = 4: 1 - 1.2B^4 + 0.6B^8
lagpol(param = c(phi1 = 1.2, phi2 = -0.6), s = 4)

# Integration operator squared: (1 - B)^2 = 1 - 2B + B^2
lagpol(param = c(delta = 1), p = 2)

# Lag polynomial using explicit coefficients
lagpol(coef = c("1"), p = 2)  # (1 - B)^2 = 1 - 2B + B^2

# Custom coefficients defined by mathematical expressions
lagpol(param = c(theta = 0.8), coef = c("2*cos(pi/6)*sqrt(theta)", "-theta"))

}
