% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_decay_optimizers.R
\name{optimizer_decay_sgdw}
\alias{optimizer_decay_sgdw}
\title{Optimizer that implements the Momentum algorithm with weight_decay}
\usage{
optimizer_decay_sgdw(
  weight_decay,
  learning_rate = 0.001,
  momentum = 0,
  nesterov = FALSE,
  name = "SGDW",
  clipnorm = NULL,
  clipvalue = NULL,
  decay = NULL,
  lr = NULL
)
}
\arguments{
\item{weight_decay}{weight decay rate.}

\item{learning_rate}{float hyperparameter >= 0. Learning rate.}

\item{momentum}{float hyperparameter >= 0 that accelerates SGD in the relevant direction and dampens oscillations.}

\item{nesterov}{boolean. Whether to apply Nesterov momentum.}

\item{name}{Optional name prefix for the operations created when applying gradients. Defaults to 'SGD'.}

\item{clipnorm}{is clip gradients by norm.}

\item{clipvalue}{is clip gradients by value.}

\item{decay}{is included for backward compatibility to allow time inverse decay of learning rate.}

\item{lr}{is included for backward compatibility, recommended to use learning_rate instead.}
}
\value{
Optimizer for use with `keras::compile()`
}
\description{
This is an implementation of the SGDW optimizer described in "Decoupled Weight Decay Regularization"
by Loshchilov & Hutter (https://arxiv.org/abs/1711.05101) ([pdf])(https://arxiv.org/pdf/1711.05101.pdf).
It computes the update step of tf.keras.optimizers.SGD and additionally decays the variable. Note that this
is different from adding L2 regularization on the variables to the loss. Decoupling the weight decay from other
hyperparameters (in particular the learning rate) simplifies hyperparameter search. For further information see
the documentation of the SGD Optimizer.
}
\examples{

\dontrun{

step = tf$Variable(0L, trainable = FALSE)
schedule = tf$optimizers$schedules$PiecewiseConstantDecay(list(c(10000, 15000)),
list(c(1e-0, 1e-1, 1e-2)))
lr = 1e-1 * schedule(step)
wd = lambda: 1e-4 * schedule(step)

}

}
