% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{decode_dynamic}
\alias{decode_dynamic}
\title{Dynamic decode}
\usage{
decode_dynamic(
  decoder,
  output_time_major = FALSE,
  impute_finished = FALSE,
  maximum_iterations = NULL,
  parallel_iterations = 32L,
  swap_memory = FALSE,
  training = NULL,
  scope = NULL,
  ...
)
}
\arguments{
\item{decoder}{A `Decoder` instance.}

\item{output_time_major}{boolean. Default: `FALSE` (batch major). If `TRUE`, outputs
are returned as time major tensors (this mode is faster). Otherwise, outputs are returned
as batch major tensors (this adds extra time to the computation).}

\item{impute_finished}{boolean. If `TRUE`, then states for batch entries which are
marked as finished get copied through and the corresponding outputs get zeroed out. This
causes some slowdown at each time step, but ensures that the final state and outputs have
the correct values and that backprop ignores time steps that were marked as finished.}

\item{maximum_iterations}{`int32` scalar, maximum allowed number of decoding steps. Default
is `NULL` (decode until the decoder is fully done).}

\item{parallel_iterations}{Argument passed to `tf$while_loop`.}

\item{swap_memory}{Argument passed to `tf$while_loop`.}

\item{training}{boolean. Indicates whether the layer should behave in training mode or
in inference mode. Only relevant when `dropout` or `recurrent_dropout` is used.}

\item{scope}{Optional variable scope to use.}

\item{...}{A list, other keyword arguments for
dynamic_decode. It might contain arguments for `BaseDecoder` to initialize, which takes
all tensor inputs during `call()`.}
}
\value{
`(final_outputs, final_state, final_sequence_lengths)`.
}
\description{
Perform dynamic decoding with `decoder`.
}
\details{
Calls `initialize()` once and `step()` repeatedly on the Decoder object.
}
\section{Raises}{

TypeError: if `decoder` is not an instance of `Decoder`. ValueError: if `maximum_iterations`
is provided but is not a scalar.
}

