% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_hardshrink}
\alias{activation_hardshrink}
\title{Hardshrink}
\usage{
activation_hardshrink(x, lower = -0.5, upper = 0.5)
}
\arguments{
\item{x}{A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.}

\item{lower}{`float`, lower bound for setting values to zeros.}

\item{upper}{`float`, upper bound for setting values to zeros. Returns: A `Tensor`. Has the same type as `x`.}
}
\value{
A `Tensor`. Has the same type as `x`.
}
\description{
Hard shrink function.
}
\details{
Computes hard shrink function:
`x if x < lower or x > upper else 0`.
}
\section{Computes hard shrink function}{

`x if x < lower or x > upper else 0`.
}

\examples{

\dontrun{
library(keras)
library(tfaddons)
model = keras_model_sequential() \%>\%
layer_conv_2d(filters = 10, kernel_size = c(3,3),input_shape = c(28,28,1),
              activation = activation_hardshrink)
}

}
